require 'rspec_helper'
require 'vaToolSet/vaToolSet_PageObject'
require 'varUtility/varUtility_PageObject'
require_relative '../module/DBUtility'

class LoginLogout
  include PageObject
  include DBUtility

  def initialize(driver)
    @driver = driver
    @vts_po  = VaToolSet_PageObject.new(@driver)
    @vaUtil_po  = VarUtility_PageObject.new(@driver)
  end

  def login(user_info)
    @vts_po.landing.login_element.when_visible(TIME_OUT_LIMIT)
    @vts_po.landing.login
    @vts_po.common.waitWhileSpinnerPresent
    @vts_po.login.login_element.when_visible(TIME_OUT_LIMIT)
    #Insert Staff Disclaimer
    setStaffUserDisclaimer(user_info["userId"], user_info["vista_location"])
    login_with(user_info["access_code"], user_info["verify_code"], user_info["station"])
    @vts_po.common.waitWhileSpinnerPresent
  end

  def login_ends_on_disclaimer(user_info, delete_disclaimer)
    @vts_po.landing.login_element.when_visible(TIME_OUT_LIMIT)
    @vts_po.landing.login
    @vts_po.common.waitWhileSpinnerPresent
    @vts_po.login.login_element.when_visible(TIME_OUT_LIMIT)
    #Insert Staff Disclaimer
    if delete_disclaimer == true
      deleteStaffUserDisclaimer(user_info["userId"])
    end

    login_with(user_info["access_code"], user_info["verify_code"], user_info["station"])
    @vts_po.common.waitWhileSpinnerPresent
  end


  def login_with(access_code, verify_code, station)
    loggedIn = false
    count = 0

    #try relogin upto 3 times
    while( not loggedIn and count < 3)
      @vts_po.login.accessCode_element.when_visible
      @vts_po.login.accessCode = access_code
      @vts_po.login.verifyCode = verify_code
      @vts_po.login.station = station[0..2]

      Watir::Wait.until {@vts_po.login.autoCompleteStation_elements[0].present?}
      autoCompleteCount = @vts_po.login.autoCompleteStation_elements.length

      puts("AutoComplete Count: " + @vts_po.login.autoCompleteStation_elements.length.to_s)

      for i in 0..autoCompleteCount
        if(@vts_po.login.autoCompleteStation_elements[i].text.include?(station))
          @vts_po.login.autoCompleteStation_elements[i].click
          break
        end
      end

      Watir::Wait.until { (@vts_po.login.station_element.value.include? station) | TIME_OUT_LIMIT }

      @vts_po.login.login
      @vts_po.common.waitWhileSpinnerPresent

      if not @vts_po.login.accessCode_element.visible?  or  @vts_po.disclaimer.ok_btn_element.visible?
        loggedIn = true
      else
        count = count + 1
      end
    end
  end

  def logout(close=true)
    @vts_po.userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
    @vts_po.userMenu.userMenu_element.click
    @vts_po.userMenu.logOut_element.focus
    @vts_po.userMenu.logOut_element.click
    if close
      @driver.close
    end

  end

end